<?php
/* --------------------------------------------------------------
   UserId.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Model;

use Gambio\Admin\UserConfiguration\Interfaces\UserId as UserIdInterface;
use Webmozart\Assert\Assert;

/**
 * Class UserId
 *
 * @package Gambio\Admin\UserConfiguration\Model
 */
class UserId implements UserIdInterface
{
    /**
     * @var int
     */
    private $value;
    
    
    /**
     * UserId constructor.
     *
     * @param int $value
     */
    private function __construct(int $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * @param int $value
     *
     * @return UserId
     */
    public static function create(int $value): UserId
    {
        Assert::greaterThan($value, 0, 'Invalid user ID provided. Got: %s');
        
        return new self($value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function userId(): int
    {
        return $this->value;
    }
}